<?php
// 1. Recebe os parâmetros
$id   = isset($_GET['id']) ? $_GET['id'] : null;
$type = isset($_GET['type']) ? $_GET['type'] : 'filme';

// 2. Redireciona se não houver ID
if (!$id) {
    header('Location: dashboard.php');
    exit;
}

// 3. Troca o tipo para TMDb (movie/tv)
$type_tmdb = ($type === 'tv' || $type === 'serie' || $type === 'série') ? 'tv' : 'movie';

// 4. Busca filme/série na API do TMDb
$tmdb_api_key = '2557fea3b40cbbd5a65e12422d017de1'; // <-- Insira sua chave!
$api_url = "https://api.themoviedb.org/3/{$type_tmdb}/{$id}?api_key={$tmdb_api_key}&language=pt-BR";

$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$result = curl_exec($ch);
curl_close($ch);

$tmdb = json_decode($result, true);

if (!$tmdb || isset($tmdb['status_code'])) {
    // Erro ao buscar
    die("<h2 style='color:#fff;background:#c00;padding:1em;border-radius:16px;text-align:center;max-width:500px;margin: 2em auto;'>Erro ao buscar dados do TMDb. Verifique o ID!</h2>");
}

// 5. Extrai dados relevantes
$titulo     = $tmdb['title']  ?? $tmdb['name']  ?? 'Título não encontrado';
$ano        = $tmdb['release_date'] ?? $tmdb['first_air_date'] ?? '';
$ano        = $ano ? substr($ano, 0, 4) : '';
$genero     = isset($tmdb['genres'][0]['name']) ? $tmdb['genres'][0]['name'] : '';
$sinopse    = $tmdb['overview'] ?? 'Sinopse não disponível.';
$poster_url = isset($tmdb['poster_path']) ? 'https://image.tmdb.org/t/p/w500' . $tmdb['poster_path'] : '';
$fundo_url  = isset($tmdb['backdrop_path']) ? 'https://image.tmdb.org/t/p/original' . $tmdb['backdrop_path'] : $poster_url;

// 6. Lida com upload de logo (opcional)
$logo_path = false;
$logo_msg = false;

if (isset($_POST['trocar_logo']) && isset($_FILES['nova_logo'])) {
    $target_dir = __DIR__ . "/uploads/";
    if (!file_exists($target_dir)) mkdir($target_dir, 0777, true);
    $imageFileType = strtolower(pathinfo($_FILES["nova_logo"]["name"], PATHINFO_EXTENSION));
    $target_file = $target_dir . "logo_" . time() . "." . $imageFileType;

    $check = getimagesize($_FILES["nova_logo"]["tmp_name"]);
    if($check !== false && $_FILES["nova_logo"]["size"] <= 5000000
        && in_array($imageFileType, ['jpg','jpeg','png'])) {
        if (move_uploaded_file($_FILES["nova_logo"]["tmp_name"], $target_file)) {
            $logo_path = 'uploads/' . basename($target_file);
            $logo_msg = "Logo enviada com sucesso!";
        } else $logo_msg = "Erro ao enviar a logo.";
    } else $logo_msg = "Apenas JPG ou PNG até 5MB.";
}

// Mantém logo da última sessão
if (!$logo_path && isset($_COOKIE['last_logo']) && file_exists($_COOKIE['last_logo'])) {
    $logo_path = $_COOKIE['last_logo'];
}
if ($logo_path) setcookie("last_logo", $logo_path, time()+3600, '/');

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Banner de <?=$titulo;?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet" />
    <style>
    :root {
        /* Cores Primárias */
        --primary-blue: #0066ff;
        --secondary-blue: #1e40af;
        --accent-blue: #3b82f6;
        --light-blue: #60a5fa;
        --dark-blue: #1e3a8a;
        --cyan: #06b6d4;

        /* Cores de Fundo e Cards */
        --bg-dark: #0f1419;
        --bg-card: #1a1f2e;
        --bg-glass: rgba(26, 31, 46, 0.85);

        /* Cores de Texto */
        --text-primary: #ffffff;
        --text-secondary: #94a3b8;

        /* Sombras e Brilhos */
        --shadow-primary: 0 8px 32px rgba(0, 102, 255, 0.25);
        --shadow-glow: 0 0 40px rgba(0, 102, 255, 0.4);
        --shadow-dark: 0 10px 30px rgba(0, 0, 0, 0.6);

        /* Gradientes */
        --gradient-primary: linear-gradient(135deg, var(--primary-blue) 0%, var(--cyan) 100%);
        --gradient-bg: linear-gradient(135deg, #0f1419 0%, #1e3a8a 100%);
        --gradient-banner-bg: linear-gradient(180deg, #0f1419 0%, #1a1f2e 50%, #0f1419 100%);
        --gradient-banner-overlay: linear-gradient(180deg, rgba(15, 20, 25, 0.5) 0%, rgba(15, 20, 25, 0.7) 20%, rgba(15, 20, 25, 0.6) 65%, rgba(15, 20, 25, 0.99) 100%);

        /* Bordas e Radios */
        --radius: 24px;
        --radius-sm: 16px;
    }

    /* Reset básico */
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        min-height: 100vh;
        background: var(--gradient-bg);
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        color: var(--text-primary);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 20px;
        position: relative;
        overflow-x: hidden; /* Evita rolagem horizontal */
    }

    /* Elemento para overlays de tela cheia */
    .full-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    /* Animação de fundo de partículas */
    .bg-animation {
        /* @extend .full-overlay; Isso é sintaxe SASS/LESS, não CSS puro. Removido. */
        position: fixed; /* Mudei para fixed para garantir que cubra a tela toda mesmo com rolagem */
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 0;
        overflow: hidden;
    }

    .particle {
        position: absolute;
        background: var(--primary-blue);
        border-radius: 50%;
        animation: float 6s ease-in-out infinite;
        opacity: 0.1;
    }

    /* Posições e atrasos para cada partícula */
    .particle:nth-child(1) { width: 8px; height: 8px; top: 20%; left: 10%; animation-delay: 0s; }
    .particle:nth-child(2) { width: 12px; height: 12px; top: 60%; left: 80%; animation-delay: 2s; }
    .particle:nth-child(3) { width: 6px; height: 6px; top: 40%; left: 60%; animation-delay: 4s; }
    .particle:nth-child(4) { width: 10px; height: 10px; top: 80%; left: 20%; animation-delay: 1s; }
    .particle:nth-child(5) { width: 14px; height: 14px; top: 30%; left: 90%; animation-delay: 3s; }

    @keyframes float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        33% { transform: translateY(-20px) rotate(120deg); }
        66% { transform: translateY(10px) rotate(240deg); }
    }

    .container {
        max-width: 700px;
        padding: 2rem;
        margin: 0 auto;
        background: var(--bg-glass);
        backdrop-filter: blur(20px);
        border-radius: var(--radius);
        box-shadow: var(--shadow-primary);
        border: 1px solid rgba(59, 130, 246, 0.2);
        position: relative;
        z-index: 10;
        animation: slideUp 0.8s ease-out;
    }

    @keyframes slideUp {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }

    h1 {
        font-size: 2.5rem;
        font-weight: 900;
        text-align: center;
        margin-bottom: 2rem;
        background: var(--gradient-primary);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        letter-spacing: -0.02em;
        animation: titleGlow 3s ease-in-out infinite alternate;
    }

    @keyframes titleGlow {
        from { filter: drop-shadow(0 0 20px rgba(0, 102, 255, 0.3)); }
        to { filter: drop-shadow(0 0 40px rgba(6, 182, 212, 0.5)); }
    }

    /* Banner principal - 1080x1350px */
    .banner-modern {
        width: 540px;
        height: 750px;
        position: relative;
        margin: 0 auto 2rem auto;
        border-radius: var(--radius);
        overflow: hidden;
        box-shadow: var(--shadow-dark);
        background: var(--gradient-banner-bg);
        border: 2px solid rgba(59, 130, 246, 0.3);
    }

    /* Fundo com overlay gradiente */
    .banner-bg {
        /* @extend .full-overlay; Removido */
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        z-index: 1;
        opacity: 0.6;
    }

    .banner-overlay {
        /* @extend .full-overlay; Removido */
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: var(--gradient-banner-overlay);
        z-index: 2;
    }

    .banner-logo-top {
        position: absolute;
        top: 1px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 5;
        max-width: 250px;
        max-height: 150px;
        object-fit: contain;
        filter: drop-shadow(0 4px 12px rgba(0,0,0,0.8));
    }

    /* Poster centralizado */
    .banner-poster-main {
        position: absolute;
        top: 150px;
        left: 50%;
        transform: translateX(-50%);
        width: 220px;
        height: 300px;
        border-radius: var(--radius-sm);
        object-fit: cover;
        z-index: 3;
        box-shadow: 0 12px 40px rgba(0,0,0,0.8);
        border: 2px solid rgba(255,255,255,0.1);
    }

    /* Conteúdo na parte inferior */
    .banner-content {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 30px 25px 80px 25px;
        z-index: 4;
        text-align: center;
        /* Adicionado para garantir que o conteúdo tenha fluxo normal */
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: flex-end; /* Alinha o conteúdo ao final (bottom) */
    }

    .banner-title-main {
        font-size: 2rem;
        font-weight: 900;
        margin-bottom: 8px;
        line-height: 1.1;
        text-shadow: 0 4px 12px rgba(0,0,0,0.9);
        letter-spacing: -0.02em;
        color: #ffffff;
    }

    .banner-meta-main {
        font-size: 1rem;
        color: var(--light-blue);
        font-weight: 600;
        margin-bottom: 12px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        text-shadow: 0 2px 8px rgba(0,0,0,0.8);
    }

    .banner-desc-main {
        font-size: 0.9rem;
        color: #e2e8f0;
        line-height: 1.4;
        max-width: 100%;
        text-shadow: 0 2px 8px rgba(0,0,0,0.9);
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        margin-bottom: 15px;
    }

    /* Ícones de plataforma na parte inferior */
    .banner-platforms {
    position: absolute; /* Mantido para posicionamento na parte inferior do banner */
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 15px;
    z-index: 4;
    align-items: center;
    justify-content: center; /* Centraliza os ícones */
    flex-wrap: wrap; /* Adicionado para quebrar linha se não couberem */
}

    .platform-icon {
        width: 40px;
        height: 40px;
        object-fit: contain;
        border-radius: 8px;
        background: rgba(255,255,255,0.10);
        box-shadow: 0 0 10px rgba(0,0,0,0.18);
        border: 1px solid rgba(255,255,255,0.10);
        padding: 5px;
        transition: transform 0.2s ease-in-out, background 0.2s ease-in-out;
    }

    .platform-icon:hover {
        transform: scale(1.08);
        background: rgba(255,255,255,0.22);
    }

    /* Formulários e controles */
    .form-section {
        background: rgba(59, 130, 246, 0.1);
        backdrop-filter: blur(10px);
        border-radius: var(--radius-sm);
        padding: 2rem;
        margin-bottom: 2rem;
        border: 1px solid rgba(59, 130, 246, 0.2);
        position: relative;
        overflow: hidden;
    }

    .form-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 2px;
        background: var(--gradient-primary);
        animation: shimmer 2s infinite;
    }

    @keyframes shimmer {
        0% { left: -100%; }
        100% { left: 100%; }
    }

    .form-section h3 {
        margin-top: 0;
        color: var(--light-blue);
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .form-section input[type="file"] {
        background: var(--bg-card);
        color: var(--text-primary);
        padding: 15px;
        border-radius: var(--radius-sm);
        border: 2px solid var(--secondary-blue);
        width: 100%;
        margin-bottom: 1.5rem;
        font-family: inherit;
        font-size: 1rem;
        transition: all 0.3s ease;
    }

    .form-section input[type="file"]:focus {
        outline: none;
        border-color: var(--primary-blue);
        box-shadow: 0 0 0 4px rgba(0, 102, 255, 0.1);
    }

    .form-section input[type="submit"] {
        background: var(--gradient-primary);
        color: #fff;
        border: none;
        padding: 15px 30px;
        border-radius: var(--radius-sm);
        cursor: pointer;
        font-weight: 700;
        font-size: 1rem;
        width: 100%;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: var(--shadow-primary);
        position: relative;
        overflow: hidden;
    }

    .form-section input[type="submit"]::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease-in-out;
    }

    .form-section input[type="submit"]:hover::before {
        left: 100%;
    }

    .form-section input[type="submit"]:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-glow);
    }

    .buttons {
        display: flex;
        gap: 1rem;
        justify-content: center;
        margin-top: 2rem;
    }

    .button {
        background: var(--gradient-primary);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        padding: 15px 25px;
        font-weight: 700;
        font-size: 1rem;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: var(--shadow-primary);
        position: relative;
        overflow: hidden;
    }

    .button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease-in-out;
    }

    .button:hover::before {
        left: 100%;
    }

    .button:hover {
        transform: translateY(-3px);
        box-shadow: var(--shadow-glow);
    }

    .button.secondary {
        background: transparent;
        color: var(--primary-blue);
        border: 2px solid var(--primary-blue);
    }

    .button.secondary:hover {
        background: var(--primary-blue);
        color: white;
    }

    .msg-ok {
        background: rgba(16, 185, 129, 0.1);
        color: #6ee7b7;
        padding: 15px;
        border-radius: var(--radius-sm);
        margin-bottom: 1.5rem;
        border: 1px solid rgba(16, 185, 129, 0.3);
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .msg-fail {
        background: rgba(239, 68, 68, 0.1);
        color: #fca5a5;
        padding: 15px;
        border-radius: var(--radius-sm);
        margin-bottom: 1.5rem;
        border: 1px solid rgba(239, 68, 68, 0.3);
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    /* Botão de voltar */
    .back-button {
        position: fixed;
        top: 24px;
        left: 24px;
        background: var(--bg-glass);
        border: 2px solid var(--primary-blue);
        border-radius: 50%;
        width: 56px;
        height: 56px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        backdrop-filter: blur(20px);
        z-index: 2000;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: var(--shadow-primary);
        text-decoration: none;
        color: var(--primary-blue);
    }

    .back-button:hover {
        transform: scale(1.1);
        box-shadow: var(--shadow-glow);
        border-color: var(--cyan);
    }

    /* --- Media Queries --- */

    @media (max-width: 768px) {
        body {
            padding: 10px;
        }

        .container {
            padding: 1rem;
            margin: 0.5rem auto; /* Centraliza o container */
            max-width: 100%; /* Garante que o container não exceda a largura da tela */
        }

        h1 {
            font-size: 1.8rem;
            margin-bottom: 1.5rem;
        }

        .banner-modern {
            width: 300px; /* Largura fixa para manter a proporção */
            height: 417px; /* Altura fixa para manter a proporção */
            margin-bottom: 1.5rem;
            /* Garante que o banner não fique muito próximo dos outros elementos */
        }

        .banner-logo-top {
            max-width: 180px;
            max-height: 100px;
            top: 5px; /* Ajuste sutil para posicionar o logo no topo */
        }

        .banner-poster-main {
            width: 150px;
            height: 225px;
            top: 110px; /* Ajuste para não sobrepor o logo e dar espaço ao título */
        }

        .banner-title-main {
            font-size: 1.4rem;
            line-height: 1.2;
            margin-bottom: 8px; /* Reduzi um pouco o espaçamento para otimizar espaço */
        }

        .banner-meta-main {
            font-size: 0.85rem;
            margin-bottom: 10px; /* Reduzi um pouco o espaçamento */
        }

        .banner-desc-main {
            font-size: 0.8rem;
            -webkit-line-clamp: 3; /* Permite até 3 linhas de texto */
            margin-bottom: 15px; /* Espaço após a descrição */
        }

        .banner-content {
            padding: 20px 15px 50px 15px; /* Aumentei o padding inferior para os ícones */
            /* Essas propriedades já estavam no seu original: */
            /* display: flex; */
            /* flex-direction: column; */
            /* align-items: center; */
            /* justify-content: flex-end; */
        }

        .banner-platforms {
            bottom: 10px; /* Mova os ícones um pouco para cima para não "colar" na borda */
            gap: 8px; /* Diminui o espaço entre os ícones */
            position: absolute; /* Mantenha absolute para fixar no banner */
            left: 50%;
            transform: translateX(-50%);
            width: 100%; /* Ocupa a largura total para centralizar melhor os ícones */
            justify-content: center; /* Centraliza os ícones */
            flex-wrap: wrap; /* Garante que os ícones quebrem a linha se não couberem */
        }

        .platform-icon {
            width: 35px;
            height: 35px;
            padding: 3px;
        }

        .buttons {
            flex-direction: column; /* Botões um abaixo do outro */
            gap: 0.8rem;
            width: 100%; /* Botões ocupam a largura total do container */
            align-items: center; /* Centraliza os botões quando em coluna */
        }

        .button {
            padding: 12px 20px;
            font-size: 0.9rem;
            width: 100%; /* Botões ocupam a largura total em mobile */
        }

        .form-section {
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .form-section h3 {
            font-size: 1.1rem;
        }
    }

    @media (max-width: 480px) {
        .container {
            padding: 0.8rem;
            margin: 0.5rem auto;
        }

        h1 {
            font-size: 1.6rem;
            margin-bottom: 1rem;
        }

        .banner-modern {
            width: 280px;
            height: 389px;
            margin-bottom: 1rem;
        }

        .banner-logo-top {
            max-width: 160px; /* Um pouco menor */
            max-height: 90px;
            top: 5px; /* Ajustado novamente */
        }

        .banner-poster-main {
            width: 130px;
            height: 195px;
            top: 95px; /* Ajuste para não sobrepor o logo */
        }

        .banner-title-main {
            font-size: 1.2rem;
            margin-bottom: 5px;
        }

        .banner-meta-main {
            font-size: 0.8rem;
            margin-bottom: 8px;
        }

        .banner-desc-main {
            font-size: 0.75rem;
            -webkit-line-clamp: 2; /* Limita a 2 linhas para economizar espaço */
            margin-bottom: 10px;
        }

        .banner-content {
            padding: 15px 10px 40px 10px;
        }

        .banner-platforms {
            bottom: 5px;
            gap: 6px;
        }

        .platform-icon {
            width: 30px;
            height: 30px;
            padding: 2px;
        }

        .form-section {
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .form-section input[type="file"],
        .form-section input[type="submit"] {
            padding: 12px;
            font-size: 0.9rem;
        }

        .back-button {
            width: 48px;
            height: 48px;
            top: 16px;
            left: 16px;
        }
    }

    @media (max-width: 360px) {
        .banner-modern {
            width: 240px;
            height: 335px;
            margin-bottom: 0.8rem;
        }

        .banner-logo-top {
            max-width: 140px; /* Ajuste para telas muito pequenas */
            max-height: 70px;
            top: 3px;
        }

        .banner-poster-main {
            width: 110px;
            height: 165px;
            top: 80px; /* Ajustado para não sobrepor o logo e dar espaço ao título */
        }

        .banner-title-main {
            font-size: 1.1rem;
            margin-bottom: 3px;
        }

        .banner-meta-main {
            font-size: 0.75rem;
            margin-bottom: 6px;
        }

        .banner-desc-main {
            font-size: 0.7rem;
            -webkit-line-clamp: 2;
            margin-bottom: 6px;
        }

        .banner-content {
            padding: 10px 8px 30px 8px;
        }

        .banner-platforms {
            bottom: 3px;
            gap: 4px;
        }

        .platform-icon {
            width: 25px;
            height: 25px;
            padding: 1px;
        }

        .form-section {
            padding: 0.8rem;
        }

        .form-section h3 {
            font-size: 1rem;
        }
    }
</style>
</head>
<body>
    <!-- Animated background -->
    <div class="bg-animation">
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
    </div>

    <!-- Back button -->
    <a href="dashboard.php" class="back-button" title="Voltar">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="m12 19-7-7 7-7"/>
            <path d="M19 12H5"/>
        </svg>
    </a>
    
    <div class="container">
        <h1>Banner Criado</h1>
        
        <!-- Banner Principal -->
        <div class="banner-modern" id="banner-para-download">
            <!-- Fundo -->
            <?php if($fundo_url): ?>
                <img src="<?=$fundo_url?>" alt="fundo" class="banner-bg" crossorigin="anonymous"/>
            <?php endif; ?>
            
            <!-- Overlay gradiente -->
            <div class="banner-overlay"></div>
            
            <!-- Logo no topo (se existir) -->
            <?php if ($logo_path && file_exists($logo_path)): ?>
                <img src="<?=$logo_path?>" alt="logo" class="banner-logo-top" crossorigin="anonymous"/>
            <?php endif; ?>
            
            <!-- Poster centralizado -->
            <?php if ($poster_url): ?>
                <img src="<?=$poster_url?>" class="banner-poster-main" alt="poster" crossorigin="anonymous"/>
            <?php endif; ?>
            
            <!-- Conteúdo na parte inferior -->
            <div class="banner-content">
                <div class="banner-title-main"><?=$titulo?></div>
                <div class="banner-meta-main">
                    <?=$ano?> <?= $genero ? "• $genero" : "" ?> • <?=ucfirst($type_tmdb === 'tv' ? 'Série' : 'Filme');?>
                </div>
                <div class="banner-desc-main"><?=$sinopse?></div>
            </div>
            
            <!-- Ícones de plataforma -->
            <div class="banner-platforms">
                <img src="img/tv.png" alt="TV" class="platform-icon" title="Smart TV" crossorigin="anonymous">
                <img src="img/remote-tv.png" alt="TV c/controle" class="platform-icon" title="Smart TV com controle" crossorigin="anonymous">
                <img src="img/desktop.png" alt="Desktop" class="platform-icon" title="Computador" crossorigin="anonymous">
                <img src="img/mobile.png" alt="Mobile" class="platform-icon" title="Smartphone" crossorigin="anonymous">
                <img src="img/signal.png" alt="Streaming" class="platform-icon" title="Conectividade" crossorigin="anonymous">
            </div>
        </div>

        <!-- Formulário para trocar logo -->
        <div class="form-section">
            <h3>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="m2.5 12 8.5-8.5L19.5 12l-8.5 8.5L2.5 12z"/>
                    <path d="M7 12h10"/>
                </svg>
                Personalizar Logo
            </h3>
            <form method="post" enctype="multipart/form-data">
                <?php if($logo_msg): ?>
                    <div class="<?=strpos($logo_msg,'sucesso')!==false?'msg-ok':'msg-fail';?>">
                        <?=strpos($logo_msg,'sucesso')!==false?'✅':'❌';?>
                        <?=$logo_msg?>
                    </div>
                <?php endif;?>
                
                <label for="nova_logo" style="display: block; margin-bottom: 0.5rem; color: var(--text-secondary); font-weight: 500;">
                    Escolha uma nova logo (PNG/JPG até 5MB):
                </label>
                <input type="file" name="nova_logo" id="nova_logo" accept="image/png, image/jpeg, image/jpg">
                <input type="submit" name="trocar_logo" value="📤 Enviar Logo">
            </form>
        </div>

        <!-- Botões de ação -->
<div class="buttons">
    <button class="button" onclick="baixarBanner()">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
            <polyline points="7,10 12,15 17,10"/>
            <line x1="12" y1="15" x2="12" y2="3"/>
        </svg>
        Baixar Banner
    </button>
    <a href="dashboard.php" class="button secondary">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
            <path d="M21 3v5h-5"/>
            <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
            <path d="M3 21v-5h5"/>
        </svg>
        Novo Banner
    </a>
</div>
</div>

<!-- Certifique-se que o banner tem id="banner-para-download" no seu HTML -->
<!-- Exemplo:
<div id="banner-para-download" class="banner-modern">
    … conteúdo do banner …
</div>
-->

<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<script>
function baixarBanner() {
    const el = document.getElementById('banner-para-download');
    if (!el) {
        alert('O elemento do banner não foi encontrado!');
        return;
    }

    // Detecta se é dispositivo móvel
    const isMobile = window.innerWidth <= 768;
    
    // Dimensões finais para download (alta qualidade)
    const larguraFinal = 1080;
    const alturaFinal = 1500;
    
    // Obter as dimensões reais do elemento na tela
    const rect = el.getBoundingClientRect();
    const larguraAtual = rect.width;
    const alturaAtual = rect.height;
    
    // Calcula o fator de escala para manter a proporção
    const scaleX = larguraFinal / larguraAtual;
    const scaleY = alturaFinal / alturaAtual;
    const scaleFactor = Math.min(scaleX, scaleY); // Usa o menor para manter proporção
    
    // Configurações otimizadas para html2canvas
    const options = {
        backgroundColor: null,
        useCORS: true,
        allowTaint: false,
        scale: 2, // Qualidade alta (2x resolução)
        width: larguraAtual,
        height: alturaAtual,
        scrollX: 0,
        scrollY: 0,
        x: 0,
        y: 0,
        windowWidth: window.innerWidth,
        windowHeight: window.innerHeight,
        // Configurações específicas para melhor renderização
        letterRendering: true,
        logging: false,
        imageTimeout: 15000,
        removeContainer: true
    };

    // Para dispositivos móveis, ajustes adicionais
    if (isMobile) {
        options.scale = 3; // Escala maior para compensar densidade de pixels
        options.pixelRatio = window.devicePixelRatio || 1;
    }

    html2canvas(el, options).then(function(canvas) {
        // Criar canvas final com dimensões exatas
        const finalCanvas = document.createElement('canvas');
        finalCanvas.width = larguraFinal;
        finalCanvas.height = alturaFinal;
        const ctx = finalCanvas.getContext('2d');
        
        // Configurar qualidade máxima
        ctx.imageSmoothingEnabled = true;
        ctx.imageSmoothingQuality = 'high';
        
        // Preencher fundo (caso seja necessário)
        ctx.fillStyle = 'transparent';
        ctx.fillRect(0, 0, larguraFinal, alturaFinal);
        
        // Calcular posição para centralizar se necessário
        const canvasWidth = canvas.width;
        const canvasHeight = canvas.height;
        
        // Calcular dimensões mantendo proporção
        const aspectRatio = canvasWidth / canvasHeight;
        const targetAspectRatio = larguraFinal / alturaFinal;
        
        let drawWidth, drawHeight, drawX, drawY;
        
        if (aspectRatio > targetAspectRatio) {
            // Canvas é mais largo - ajustar pela altura
            drawHeight = alturaFinal;
            drawWidth = drawHeight * aspectRatio;
            drawX = (larguraFinal - drawWidth) / 2;
            drawY = 0;
        } else {
            // Canvas é mais alto - ajustar pela largura
            drawWidth = larguraFinal;
            drawHeight = drawWidth / aspectRatio;
            drawX = 0;
            drawY = (alturaFinal - drawHeight) / 2;
        }
        
        // Desenhar a imagem no canvas final
        ctx.drawImage(canvas, drawX, drawY, drawWidth, drawHeight);
        
        // Fazer download
        baixarImagem(finalCanvas);
        
    }).catch(function(error) {
        console.error('Erro ao gerar banner:', error);
        
        // Fallback: tentar novamente com configurações mais simples
        html2canvas(el, {
            backgroundColor: null,
            useCORS: true,
            scale: 1,
            logging: false
        }).then(function(fallbackCanvas) {
            // Download direto sem redimensionamento
            baixarImagem(fallbackCanvas, 'banner_original.png');
        }).catch(function(fallbackError) {
            console.error('Erro no fallback:', fallbackError);
            alert('Erro ao gerar o banner. Verifique se todos os elementos estão carregados e tente novamente.');
        });
    });
}

function baixarImagem(canvas, nomeArquivo = 'banner_moderno_1080x1500.png') {
    try {
        // Criar link temporário para download
        const link = document.createElement('a');
        link.download = nomeArquivo;
        
        // Converter canvas para blob (melhor compatibilidade)
        canvas.toBlob(function(blob) {
            const url = URL.createObjectURL(blob);
            link.href = url;
            
            // Adicionar ao DOM temporariamente e clicar
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            
            // Limpar URL temporária
            setTimeout(() => URL.revokeObjectURL(url), 100);
            
        }, 'image/png', 1.0); // Qualidade máxima
        
    } catch (error) {
        console.error('Erro ao baixar imagem:', error);
        // Fallback para método antigo
        const link = document.createElement('a');
        link.download = nomeArquivo;
        link.href = canvas.toDataURL('image/png');
        link.click();
    }
}

// Aguardar carregamento completo antes de permitir download
document.addEventListener('DOMContentLoaded', function() {
    // Aguardar um pouco mais para garantir que tudo carregou
    setTimeout(function() {
        console.log('Sistema de download de banner carregado');
    }, 1000);
});
</script>