<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Login - Gerador de Banner Moderno</title>
    <meta name="description" content="Fa04a login para acessar o Gerador de Banner Moderno.">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet" />
    <style>
        html { scroll-behavior: smooth; }
        
        :root {
            --primary-blue: #0066ff;
            --secondary-blue: #1e40af;
            --accent-blue: #3b82f6;
            --light-blue: #60a5fa;
            --dark-blue: #1e3a8a;
            --cyan: #06b6d4;
            --bg-dark: #0f1419;
            --bg-card: #1a1f2e;
            --bg-glass: rgba(26, 31, 46, 0.85);
            --text-primary: #ffffff;
            --text-secondary: #94a3b8;
            --shadow-primary: 0 8px 32px rgba(0, 102, 255, 0.25);
            --shadow-glow: 0 0 40px rgba(0, 102, 255, 0.4);
            --gradient-primary: linear-gradient(135deg, var(--primary-blue) 0%, var(--cyan) 100%);
            --gradient-bg: linear-gradient(135deg, #0f1419 0%, #1e3a8a 100%);
            --radius: 24px;
            --radius-sm: 16px;
        }

        body.light-theme {
            --bg-dark: #f8fafc;
            --bg-card: #ffffff;
            --bg-glass: rgba(255, 255, 255, 0.95);
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --gradient-bg: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            --shadow-primary: 0 8px 32px rgba(0, 102, 255, 0.15);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--gradient-bg);
            color: var(--text-primary);
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
            transition: all 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .bg-banners {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            overflow: hidden;
        }

        .banner-slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            opacity: 0;
            transition: opacity 2s ease-in-out;
            filter: blur(2px) brightness(0.3);
        }

        .banner-slide.active {
            opacity: 1;
        }

        .banner-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(
                135deg,
                rgba(15, 20, 25, 0.8) 0%,
                rgba(30, 58, 138, 0.6) 50%,
                rgba(15, 20, 25, 0.8) 100%
            );
            z-index: 1;
        }

        .floating-posters {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 2;
            overflow: hidden;
        }

        .floating-poster {
            position: absolute;
            width: 120px;
            height: 180px;
            background-size: cover;
            background-position: center;
            border-radius: 12px;
            opacity: 0.1;
            animation: floatPoster 20s linear infinite;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        @keyframes floatPoster {
            0% {
                transform: translateY(100vh) translateX(0) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 0.1;
            }
            90% {
                opacity: 0.1;
            }
            100% {
                transform: translateY(-200px) translateX(100px) rotate(360deg);
                opacity: 0;
            }
        }

        .login-container {
            background: var(--bg-glass);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: var(--radius);
            padding: 3rem;
            box-shadow: var(--shadow-primary);
            position: relative;
            overflow: hidden;
            animation: slideUp 0.8s ease-out;
            width: 90%;
            max-width: 450px;
            text-align: center;
            z-index: 10;
        }

        .login-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 2px;
            background: var(--gradient-primary);
            animation: shimmer 2s infinite;
        }

        @keyframes shimmer {
            0% { left: -100%; }
            100% { left: 100%; }
        }

        @keyframes slideUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .login-title {
            font-size: 2.5rem;
            font-weight: 800;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
            letter-spacing: -0.02em;
        }

        .login-subtitle {
            color: var(--text-secondary);
            font-size: 1.1rem;
            margin-bottom: 2rem;
            font-weight: 500;
        }

        .login-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .input-group {
            position: relative;
        }

        .login-input {
            width: 100%;
            height: 55px;
            background: var(--bg-card);
            border: 2px solid var(--secondary-blue);
            border-radius: var(--radius-sm);
            padding: 0 1.5rem;
            font-size: 1.1rem;
            color: var(--text-primary);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-family: inherit;
        }

        .login-input::placeholder {
            color: var(--text-secondary);
        }

        .login-input:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 4px rgba(0, 102, 255, 0.1);
        }

        .login-btn {
            height: 55px;
            background: var(--gradient-primary);
            border: none;
            border-radius: var(--radius-sm);
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: var(--shadow-primary);
            position: relative;
            overflow: hidden;
            margin-top: 1rem;
        }

        .login-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .login-btn:hover::before {
            left: 100%;
        }

        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-glow);
        }

        .login-btn:active {
            transform: translateY(0);
        }

        .message {
            margin-top: 1.5rem;
            padding: 1rem;
            border-radius: var(--radius-sm);
            font-size: 0.95rem;
            font-weight: 500;
        }

        .message.error {
            background-color: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #fca5a5;
        }

        .message.success {
            background-color: rgba(16, 185, 129, 0.1);
            border: 1px solid rgba(16, 185, 129, 0.3);
            color: #6ee7b7;
        }

        .toggle-theme {
            position: fixed;
            top: 24px;
            right: 24px;
            background: var(--bg-glass);
            border: 2px solid var(--primary-blue);
            border-radius: 50%;
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            backdrop-filter: blur(20px);
            z-index: 2000;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: var(--shadow-primary);
        }

        .toggle-theme:hover {
            transform: scale(1.1);
            box-shadow: var(--shadow-glow);
            border-color: var(--cyan);
        }

        .toggle-theme svg {
            width: 28px;
            height: 28px;
            stroke: var(--primary-blue);
            fill: none;
            transition: all 0.3s ease;
        }

        .loading-spinner {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 5;
            display: none;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid var(--primary-blue);
            border-top: 4px solid transparent;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .movie-info {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: var(--bg-glass);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: 12px;
            padding: 1rem;
            max-width: 300px;
            z-index: 15;
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .movie-info.show {
            opacity: 1;
        }

        .movie-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: var(--text-primary);
        }

        .movie-overview {
            font-size: 0.9rem;
            color: var(--text-secondary);
            line-height: 1.4;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        @media (max-width: 768px) {
            .movie-info {
                display: none;
            }
            
            .floating-poster {
                width: 80px;
                height: 120px;
            }
        }
    </style>
</head>
<body>
    <div class="loading-spinner" id="loadingSpinner">
        <div class="spinner"></div>
    </div>

    <div class="bg-banners" id="bgBanners">
        <div class="banner-overlay"></div>
    </div>

    <div class="floating-posters" id="floatingPosters"></div>

    <button class="toggle-theme" aria-label="Alternar tema" onclick="toggleTheme()">
        <svg viewBox="0 0 24 24" stroke-width="2">
            <circle cx="12" cy="12" r="5"/>
            <line x1="12" y1="1" x2="12" y2="3"/>
            <line x1="12" y1="21" x2="12" y2="23"/>
            <line x1="4.22" y1="4.22" x2="5.64" y2="5.64"/>
            <line x1="18.36" y1="18.36" x2="19.78" y2="19.78"/>
            <line x1="1" y1="12" x2="3" y2="12"/>
            <line x1="21" y1="12" x2="23" y2="12"/>
            <line x1="4.22" y1="19.78" x2="5.64" y2="18.36"/>
            <line x1="18.36" y1="5.64" x2="19.78" y2="4.22"/>
        </svg>
    </button>

    <div class="login-container">
        <h1 class="login-title">Acesso Restrito</h1>
        <p class="login-subtitle">Cinema em cada frame</p>
        <form class="login-form" action="processa_login.php" method="POST">
            <div class="input-group">
                <input type="email" class="login-input" name="email" placeholder="Seu e-mail" required>
            </div>
            <div class="input-group">
                <input type="password" class="login-input" name="senha" placeholder="Sua senha" required>
            </div>
            <button type="submit" class="login-btn">Entrar</button>
        </form>
        <div id="message" class="message"></div>
    </div>

    <div class="movie-info" id="movieInfo">
        <div class="movie-title" id="movieTitle"></div>
        <div class="movie-overview" id="movieOverview"></div>
    </div>

    <script>
        const API_KEY = '2557fea3b40cbbd5a65e12422d017de1';
        const BASE_URL = 'https://api.themoviedb.org/3';
        const IMAGE_BASE_URL = 'https://image.tmdb.org/t/p/w1280';
        const POSTER_BASE_URL = 'https://image.tmdb.org/t/p/w500';

        let movies = [];
        let currentBannerIndex = 0;
        let bannerInterval;

        // Fun0400o para buscar filmes populares
        async function fetchPopularMovies() {
            try {
                document.getElementById('loadingSpinner').style.display = 'block';
                const response = await fetch(`${BASE_URL}/movie/popular?api_key=${API_KEY}&language=pt-BR&page=1`);
                const data = await response.json();
                movies = data.results.filter(movie => movie.backdrop_path && movie.poster_path);
                document.getElementById('loadingSpinner').style.display = 'none';
                initializeBanners();
                startFloatingPosters();
            } catch (error) {
                console.error('Erro ao buscar filmes:', error);
                document.getElementById('loadingSpinner').style.display = 'none';
                // Fallback para gradiente padr00o
                document.body.style.background = 'var(--gradient-bg)';
            }
        }

        // Fun0400o para inicializar os banners de fundo
        function initializeBanners() {
            const bgBanners = document.getElementById('bgBanners');
            
            // Criar slides de banner
            movies.slice(0, 10).forEach((movie, index) => {
                const slide = document.createElement('div');
                slide.className = 'banner-slide';
                slide.style.backgroundImage = `url(${IMAGE_BASE_URL}${movie.backdrop_path})`;
                if (index === 0) slide.classList.add('active');
                bgBanners.appendChild(slide);
            });

            // Iniciar rota0400o de banners
            startBannerRotation();
        }

        // Fun0400o para rotacionar banners
        function startBannerRotation() {
            const slides = document.querySelectorAll('.banner-slide');
            
            bannerInterval = setInterval(() => {
                slides[currentBannerIndex].classList.remove('active');
                currentBannerIndex = (currentBannerIndex + 1) % slides.length;
                slides[currentBannerIndex].classList.add('active');
                
                // Mostrar informa0401es do filme atual
                showMovieInfo(movies[currentBannerIndex]);
            }, 5000);
        }

        // Fun0400o para mostrar informa0401es do filme
        function showMovieInfo(movie) {
            const movieInfo = document.getElementById('movieInfo');
            const movieTitle = document.getElementById('movieTitle');
            const movieOverview = document.getElementById('movieOverview');
            
            movieTitle.textContent = movie.title;
            movieOverview.textContent = movie.overview;
            
            movieInfo.classList.add('show');
            
            setTimeout(() => {
                movieInfo.classList.remove('show');
            }, 4000);
        }

        // Fun0400o para criar posters flutuantes
        function startFloatingPosters() {
            const container = document.getElementById('floatingPosters');
            
            function createFloatingPoster() {
                if (movies.length === 0) return;
                
                const poster = document.createElement('div');
                poster.className = 'floating-poster';
                
                const randomMovie = movies[Math.floor(Math.random() * movies.length)];
                poster.style.backgroundImage = `url(${POSTER_BASE_URL}${randomMovie.poster_path})`;
                poster.style.left = Math.random() * (window.innerWidth - 120) + 'px';
                poster.style.animationDelay = Math.random() * 2 + 's';
                poster.style.animationDuration = (15 + Math.random() * 10) + 's';
                
                container.appendChild(poster);
                
                // Remover o poster aps a anima0400o
                setTimeout(() => {
                    if (poster.parentNode) {
                        poster.parentNode.removeChild(poster);
                    }
                }, 25000);
            }
            
            // Criar posters em intervalos regulares
            setInterval(createFloatingPoster, 3000);
        }

        // Fun0400o para alternar tema
        function toggleTheme() {
            document.body.classList.toggle('light-theme');
        }

        // Lidar com mensagens da URL
        document.addEventListener('DOMContentLoaded', () => {
            const urlParams = new URLSearchParams(window.location.search);
            const message = urlParams.get('message');
            const type = urlParams.get('type');
            const messageDiv = document.getElementById('message');

            if (message && type) {
                messageDiv.textContent = decodeURIComponent(message);
                messageDiv.classList.add(type);
                setTimeout(() => {
                    messageDiv.textContent = '';
                    messageDiv.classList.remove(type);
                }, 5000);
            }

            // Inicializar banners TMDB
            fetchPopularMovies();
        });

        // Pausar anima0401es quando a pgina n00o est visvel
        document.addEventListener('visibilitychange', () => {
            if (document.hidden) {
                if (bannerInterval) clearInterval(bannerInterval);
            } else {
                if (movies.length > 0) startBannerRotation();
            }
        });
    </script>
</body>
</html>